#ifndef __C4DBASETRACK_H
#define __C4DBASETRACK_H

#include "c4d_baselist.h"
#include "operatingsystem.h"
#include "ge_vector.h"

class BaseObject;
class BaseDocument;
class BaseSequence;
class BaseKey;

class BaseTrack : public BaseList2D
{
	private:
		BaseTrack(void);
	public:
		BaseList2D    *GetObject(void) { return (BaseList2D*)AtCall(GetMain)(); }

		BaseSequence	*GetFirstSequence(void);
		Bool					InsertSequence(BaseSequence *bs, Bool check=TRUE);
		Bool					AnimateObject(BaseDocument *doc, BaseList2D *op, const BaseTime &time, LONG flags, void *data=NULL);
		BaseSequence	*FindSequence(const BaseTime &time);
		BaseSequence	*AutoAddSequence(BaseDocument *doc, const BaseTime &time);

		BaseTrack *GetNext(void) { return (BaseTrack*)AtCall(GetNext)(); }
		BaseTrack *GetPred(void) { return (BaseTrack*)AtCall(GetPred)(); }

		const DescID &GetDescriptionID(void);

		static BaseTrack *Alloc(LONG type);
		static void Free(BaseTrack *&bl);
};

BaseTrack *AllocValueTrack(Atom *op, const DescID &id);
BaseTrack *AllocDataTrack(Atom *op, const DescID &id);
BaseTrack *AllocTimeTrack();

class PluginTrack : public BaseTrack
{
	public:
		static PluginTrack *Alloc(LONG type);
		static void Free(PluginTrack *&key);
};

#endif
